<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateDriverFiananceRequest;
use App\Http\Requests\Admin\StoreDriverFiananceRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\DriverFiananceOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\DriverFianance;
use Auth;

class DriverFinanceController extends Controller
{
    use DriverFiananceOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('Permission:city_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:city_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:city_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:city_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $driver_finances = DriverFianance::get();
        $title = 'حسابات السائقين';
        return view('admin.driver-finances.index', compact('driver_finances', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.cities.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreDriverFiananceRequest $request)
    {
        $this->register($request);
      
        return redirect('/dashboard/driver-finances')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(DriverFianance $driver_finances)
    {
        $title = 'عرض ';
        return view('admin.cities.show', compact('driver_finances', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $driver_finances = DriverFianance::find($id);
        $title = 'تعديل ';
        return view('admin.cities.edit', compact('driver_finances', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateDriverFiananceRequest $request, $id)
    {
      
        $driver_finances = DriverFianance::find($id);
        $this->UpdateRecords($driver_finances, $request);
      
        return redirect('/dashboard/cities')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(DriverFianance $driver_finances)
    {
        if ($driver_finances->image) {
            @unlink(public_path('/cdn/'.$driver_finances->image));
        }
        $driver_finances->delete();
        return 'success';
    }

   
    
}
