<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Company;
use App\Models\Driver;
use App\Models\Transfer;
use App\Models\Order;
use PDF;

class PdfController extends Controller
{
    public function companyPdf( $id)
    {
        $company = Company::find($id);
        $title = 'شركة : '. $company->name;
            $pdf1 = PDF::loadView('admin.reports.pdf.company', compact('company', 'title'));
            return $pdf1->download('document.pdf');
            $order = Order::find($id);
    }
    public function companyFinancePdf( $id)
    {
        $company = Company::find($id);
        $title = 'شركة : '. $company->name;
            $pdf1 = PDF::loadView('admin.reports.pdf.company-finance', compact('company', 'title'));
            return $pdf1->download('document.pdf');
    }
    public function CcompanyFinancePdf()
    {
        $company = auth('company')->user();
        $title = 'شركة : '. $company->name;
            $pdf1 = PDF::loadView('admin.reports.pdf.company-finance', compact('company', 'title'));
            return $pdf1->download('document.pdf');
    }


    public function driverPdf( $id)
    {
        $driver = Driver::find($id);
        $title = 'سائق : '. $driver->name;
            $pdf = PDF::loadView('admin.reports.pdf.driver', compact('driver', 'title'));
            return $pdf->download('document.pdf');
    }

    public function transferPdf( $id)
    {
        $transfer = Transfer::find($id);
        
        $invoices = $transfer->Invoice()->get();
        $title = 'فاتورة : '. $transfer->Company->name ?? '';
            $pdf = PDF::loadView('admin.reports.pdf.transfer', compact('transfer', 'title', 'invoices'));
            return $pdf->download(str_slug($transfer->Company->name).'.pdf');
    }


    public function orderPdf( $id)
    {
        $order = Order::find($id);
        $title = 'طلب : '. $order->name;
            $pdf = PDF::loadView('admin.reports.pdf.order', compact('order', 'title'));
            return $pdf->download('document.pdf');
    }

    public function invoicePdf( $id)
    {
        $invoice = Invoice::find($id);
        $title = 'فاتورة : '. $invoice->name;
            $pdf = PDF::loadView('admin.reports.pdf.invoice', compact('invoice', 'title'));
            return $pdf->download('document.pdf');
    }
}
