<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Models\OrderStatus;
use App\Models\FeedBack;

class AppInfoController extends Controller
{
    public function index()
    {

        $info = Setting::pluck('value', 'key')->toArray();
        
        return Response()->json([
                'data' => [
                    'info' => $info,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function getStatuses()
    {

        $statuses = OrderStatus::get();
        
        return Response()->json([
                'data' => [
                    'statuses' => $statuses,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
}
