<?php

namespace App\Http\Controllers\Api\Company;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;
use App\Models\Invoice;

class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function statistics()
    {
      $company = Auth::guard('api-company')->user();
      $orders_not_recieved = $company->Order()->where('status', '<>', 'completed')->sum('price');
      $money_waiting_for_transfer = $company->Transfer()->where('active', 0)->sum('company_price');
      $money_transfered = $company->Transfer()->where('active', 1)->sum('company_price');
      $delivery_cost = $company->Transfer()->where('active', 0)->sum('madar_price');
      $delivery_cost_collected = $company->Transfer()->where('active', 1)->sum('madar_price');
      
      $orders = $company->Order()->whereHas('Invoice')->latest()->limit(30)->pluck('id');
      $invoices = Invoice::whereIn('order_id', $orders)->get();
      return Response()->json([
                'data' => [
                    'orders_not_recieved' => $orders_not_recieved,
                    'money_waiting_for_transfer' => $money_waiting_for_transfer,
                    'money_transfered' => $money_transfered,
                    'delivery_cost' => $delivery_cost,
                    'delivery_cost_collected' => $delivery_cost_collected,
                    'invoices' => $invoices,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);

    }
    public function invoices()
    {
      $company = Auth::guard('api-company')->user();
      $orders = $company->Order()->whereHas('Invoice')->latest()->pluck('id');
      $invoices = Invoice::whereIn('order_id', $orders)->paginate(30);
      return Response()->json([
                'data' => [
                    'invoices' => $invoices,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);

    }
    public function transfers()
    {
      $company = Auth::guard('api-company')->user();
      $transfers = $company->Transfer()->paginate(30);
      return Response()->json([
                'data' => [
                    'transfers' => $transfers,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $company = Auth::guard('api-company')->user();
        $order = $company->Order()->findOrfail($id);
        $logs = $order->OrderLog()->get();
        return Response()->json([
                'data' => [
                    'order' => $order,
                    'logs' => $logs,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
