<?php

namespace App\Http\Controllers\Api\Company;

use App\Http\Requests\Api\UpdateCompanyRequest;
use App\Http\Controllers\Controller;
use App\Traits\Api\CompanyOperations;
use Illuminate\Http\Request;
use App\Models\Company;
use Carbon\Carbon;
use Auth;
use Mail;
use Tymon\JWTAuth\Facades\JWTAuth;
use Validator;

class ProfileController extends Controller
{
    use CompanyOperations;
    public function profile(Request $request)
    {
        $company = Auth::guard('api-company')->user();
        return Response()->json([
                'data' => [
                    'company' => $company
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function update(Request $request)
    {
        $company = Auth::guard('api-company')->user();
        
        $this->UpdateRecords($company, $request);
        $company = Company::find($company->id);
        $company->token = auth('api-company')->tokenById($company->id);
        return Response()->json([
                'data' => [
                    'company' => $company
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function notifications(Request $request)
    {
        $user = auth('api-company')->user();
        $notifications  = $user->unreadnotifications;
        if ($request->has('son_id') && $request->get('son_id') != '') {
            $son_id = $request->get('son_id');
            $notifications = $user->unreadnotifications()
                                ->where('data','LIKE','%"son":{"id":'.$son_id.'%')
                                // ->orWhere('data','LIKE','%"status":"0"%')
                                ->get();
        }
        // return $notifications;
        return Response()->json([
                'data' => [
                    'notifications' => $notifications
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
}
