<?php

namespace App\Http\Controllers\Api\Driver;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;
use App\Models\Driver;
use App\Models\Order;
use App\Models\OrderStatus;
use Carbon\Carbon;
class OrderController extends Controller
{
    public function index()
    {
        $driver = Auth::guard('api-driver')->user();
        $orders = $driver->Order()->get();
        return Response()->json([
                'data' => [
                    'orders' => $orders
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function show($id)
    {
        $driver = Auth::guard('api-driver')->user();
        $order = $driver->Order()->find($id);
        if (!$order) {
            return Response()->json([
                'data' => [
                ],
                'message' => 'not found',
                'code' => getMsgCode('notFound')
            ]);
        }
        $levels = Order::getLevels($order->status);
        $statuses = OrderStatus::whereIn('key', $levels)->get();
        return Response()->json([
                'data' => [
                    'order' => $order,
                    'statuses' => $statuses,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function accept(Request $request)
    {
        $driver = auth('api-driver')->user();
        $data = [];
        $data['status_id'] = OrderStatus::where('key', 'accepted')->first()->id;
        $data['status'] = OrderStatus::where('key', 'accepted')->first()->key;
        $order = Order::find($request->order_id);
        if (!$order) {
            return Response()->json([
                'data' => [
                ],
                'message' => 'not found',
                'code' => getMsgCode('notFound')
            ]);
        }
        $order->update($data);
        

        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
   
    public function refuse(Request $request)
    {
        $driver = auth('api-driver')->user();
        $data = [];
        $order = Order::find($request->order_id);
        if (!$order) {
            return Response()->json([
                'data' => [
                ],
                'message' => 'not found',
                'code' => getMsgCode('notFound')
            ]);
        }
        $order->driver_id = null;
        $order->save();

        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function changestatus(Request $request)
    {
        $driver = auth('api-driver')->user();
        $data = [];
        $order = Order::find($request->order_id);
        if (!$order) {
            return Response()->json([
                'data' => [
                ],
                'message' => 'not found',
                'code' => getMsgCode('notFound')
            ]);
        }
        $status = $request->get('status');
        // $data['price'] = ;
        // $data['commission'] = ;
        $data['status_id'] = OrderStatus::where('key', $status)->first()->id;
        $data['status'] = $status;
        // $data['driver_id'] = $driver->id;
        $order->update($data);
       

        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
}
