<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use App\Models\City;
use App\Models\PaymentMethod;
use App\Models\Company;
use App\Models\Order;
use Auth;

class ServiceController extends Controller
{
    public function info()
    {
        // 
        $cities = City::get();
        $payment_methods = PaymentMethod::get();
        return response()->json([
            'cities' => $cities,
            'payment_methods' => $payment_methods,
            'message' => 'allowed cities',
            'success' => true
        ], 200);
    }
    public function getToken(Request $request)
    {
        $email = $request->get('email');
        $password = $request->get('password');
        if (Auth::guard('company')->attempt(['email' => $email, 'password' => $password ])) {
            $com = auth('company')->user();
            $com->rest_token = md5($com->id . time());
            $com->save();
            $token = auth('company')->user()->rest_token;
            return response()->json([
                'token' => $token,
                'message' => 'rest token',
                'success' => true
            ], 200);
        }
        return response()->json([
            'errors' => [],
            'message' => 'invaild account',
            'success' => false
        ], 200);
    }
    public function addOrder(Request $request)
    {
        $rest_token = Request()->get('rest_token');
        $com = Company::where('rest_token', $rest_token)->first();
        if (!$com) {
            return response()->json([
                'errors' => [],
                'message' => 'token error',
                'success' => false
            ], 200);
        }
        $data = $request->all();
        $rules = [
            'recipient_name' => 'required|max:255' ,
            'recipient_phone' => 'required|max:255' , 
            'city_id' => 'required|exists:cities,id' ,
            'adress_details' => 'required|max:255' ,
            'packages_number' => 'required|max:11' ,
            'price' => 'required|max:11' ,
            'notes' => 'nullable' ,
            'payment_method_id' => 'required|exists:payment_methods,id' ,
            'refrence_no' => 'required|max:255' ,

        ];
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors(),
                'message' => 'validation error',
                'success' => false
            ], 200);
        }
        $data['recipent_name'] = $request->recipient_name;
        $data['phone'] = $request->recipient_phone;
        $Order = $com->Order()->create($data);
        $s = str_replace(' ', '',date('Y m').$Order->id);
        $serial = 'mx-'.$s;
        $Order->update(['serial' => $serial, 'serial_no' => (int)$s]);
        //////////////////////// the date of creation order
        $Order->OrderLog()->create([
            'status' => 'init',
            'details' =>  trans('words.'.'init')
        ]);
        return response()->json([
            'message' => 'success',
            'success' => true
        ], 200);
    }
    public function getHistory()
    {
        $rest_token = Request()->get('rest_token');
        $id = Request()->get('order_id');
        $com = Company::where('rest_token', $rest_token)->first();
        if (!$com) {
            return response()->json([
                'errors' => [],
                'message' => 'token error',
                'success' => false
            ], 200);
        }
        $order = Order::Where('refrence_no',$id)->orWhere('serial',$id)->first();
        if (!$order) {
            return response()->json([
                'errors' => [],
                'message' => 'order not found',
                'success' => false
            ], 200);
        }
        $history = $order->OrderLog()->select('status', 'details')->get();
        return response()->json([
            'history' => $history,
            'message' => 'order history',
            'success' => true
        ], 200);
    }
}
