<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactUs;
use App\Models\Order;
use App\Models\Company;
use Mail;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }

    public function PostForm(Request $request)
    {
        ContactUs::create($request->all());
        $res = [
            'code' => 200,
            'message' => ''
        ];
        $data = $request->all();
        try {
            //code...
        Mail::send('mails.reminder', ['data' => $data], function ($m) use ($data) {
            $m->from('info@madarex.sa', 'طلبات عرض اسعار');

            $m->to($data['email'],$data['name'])->subject('طلبات عرض اسعار  !');
        });
        ///////////// to handle error 
        } catch (\Throwable $th) {
            //throw $th;
        }
        return $res;



    }
    // public function getOrderStatus($id)
    // {
    //     $order = Order::find($id);
    //     if(!$order)
    //     {
    //         $res = [
    //             'code' => 404,
    //             'message' => 'عفوا حدث خطأ ما يرجي التاكد من رقم الشحنة.'
    //         ];
    //         return $res;
    //     }
    //     $res = [
    //         'code' => 404,
    //         'message' => trans('words.'.$order->status)
    //     ];
    //     return $res;


    // }
    public function getOrderStatus($id)
    {
        ////////////////////////////////////
        $order = Order::Where('refrence_no',$id)->orWhere('serial',$id)->first();
        $html = '';
        $i = 0;
        $class = 'done';
        // foreach(OrderStatus() as $key => $value)
        // {
        //     if($order->status == $key)
        //     {
        //         $html .= '<div class="col-lg-4">
        //                                 <div class="one-state '.$class.'">
        //                                     <img style="width: 60px;" src="https://image.flaticon.com/icons/svg/984/984233.svg">
        //                                     <h4> '.$value.' </h4>
        //                                 </div>
        //                             </div>';
        //         $class= "to-do";
        //     }else{
        //         $html .= '<div class="col-lg-4">
        //                                 <div class="one-state '.$class.'">
        //                                     <i class="fa fa-check"></i>
        //                                     <h4> '.$value.' </h4>
        //                                 </div>
        //                             </div>';
        //     }
            
            
        // }
        // $html .= '<div class="col-md-12 text-right" style="background-color:#fff;">
        //                 <table class="table table-bordered">
        //                 <thead>
        //                 <tr>
        //                 <th style="text-align:right;">التاريخ</th>
        //                 <th style="text-align:right;">الحالة</th>
        //                 </tr>
        //                 </thead>
        //                 <tbody>
        //                 ';
        //     foreach ($order->OrderLog()->get() as $item) {
        //         $html.='<tr><td>'.$item->created_at->toDateString().'</td><td>'.$item->details.'</td></tr>';
        //     }
        //     $html.= '</tbody></table></div>';
        if(!$order)
        {
            $res = [
                'code' => 404,
                'html' => $html,
                'message' => 'الشحنه غير موجوده.'
            ];
            return $res;
        }
        $res = [
            'code' => 200,
            'html' => view('front.ajex.order-status', compact('order', 'class'))->render(),
            'message' => trans('words.'.$order->status)
        ];
        return $res;


    }
    public function getOrderStatusCh(Request $request)
    {
        $id = $request->get('order_id');
        $order = Order::Where('refrence_no',$id)->orWhere('serial',$id)->first();
        $html = '';
        $i = 0;
        $class = 'done';
        if(!$order)
        {
            $res = [
                'code' => 404,
                'html' => $html,
                'message' => 'الشحنه غير موجوده.'
            ];
            return 'الشحنه غير موجوده.';
        }
        $res = [
            'code' => 200,
            'html' => view('front.ajex.order-status', compact('order', 'class'))->render(),
            'message' => trans('words.'.$order->status)
        ];
        return strip_tags($res['html']);


    }

    public function Register(Request $request)
    {
        return view('auth.com-reg');
    }

    public function RegisterPost(Request $request)
    {
        $data = $request->all();
        $rules = [
            'name'          => 'required|max:255',
            'email'         => 'required|email|unique:companies|max:255',
            'phone'         => 'required|unique:companies|max:255',
            'commercial_record'         => 'required|unique:companies|max:255',
            'password'      => 'required|confirmed|max:255|min:6',
            'image'         => 'nullable|image',
        ];
        $this->validate($request, $rules);
        $data['active'] = 0;
        $data['password'] = bcrypt($request->password) ;
        Company::create($data);
        return redirect('/')->with('success' , 'تم انشاء الحساب بنجاح و جاري مراجعه البيانات من الادارة');
    }


}
