<?php

function getSettingValue($key)
{
    $row = \App\Models\Setting::where('key', $key)->first();
    if ($row) {
        return $row->value;
    }
    return '';
}

function uploadFile($request)
{
    $filename = rand(99999, 99999999) . time(). '.' . $request->file('image')->getClientOriginalExtension();
    $request->file('image')->move(public_path('/cdn'), $filename);
    // $profileimg  = $filename;
    return $filename;
}

function uploadImage($file)
{
    $filename = rand(99999, 99999999) . time(). '.' . $file->getClientOriginalExtension();
    $file->move(public_path('/cdn'), $filename);
    // $profileimg  = $filename;
    return $filename;
}
 
function FileHtmlContent($file)
{
    // return $file;
    try{
        if(strpos($file, url('/')) !== false) {
            $file = str_replace( url('/'). '/cdn/', '', $file);
        }
        $file2 = public_path('/cdn/'.$file);
        $type = exif_imagetype($file2);
        switch($type) {
          case IMG_GIF:
            $type = 'image/gif';
            break;
          case IMG_JPG:
            $type = 'image/jpg';
            break;
          case IMG_JPEG:
            $type = 'image/jpeg';
            break;
          case IMG_PNG:
            $type = 'image/png';
            break;
          case IMG_WBMP:
            $type = 'image/wbmp';
            break;
          case IMG_XPM:
            $type = 'image/xpm';
            break;
          default: 
            $type = 'unknown';
        }

    }catch(\Exception $e){
        return '';
    }
    $file = GetImage($file);
    if(    str_contains($type, 'image')    )
    {
        $type = 'image';
    }
    switch ($type) {
        case 'image':
            return '<img src="'.$file.'" class="image-responsive" style="height:150px; width:100%;" />';
            break;
        
        default:
            return '<center><a href="'.$file.'"><i class="fa fa-file-text" aria-hidden="true" style=font-size:124px;></i>
</a></center>';
            break;
    }
}

function uploadImageBase64($file)
{

    // $filename = rand(99999, 99999999) . time(). '.' . $file->getClientOriginalExtension();
    $image = $file;  // your base64 encoded
    $image = str_replace('data:image/png;base64,', '', $image);
    $image = str_replace(' ', '+', $image);
    // $filename = str_random(10).'.'.'png';
   $filename = 'image_'.rand(99999, 99999999) .time().'.png'; //generating unique file name; 
   @list($type, $file_data) = explode(';', $image);
   @list(, $image) = explode(',', $image); 
    \File::put(public_path(). '/cdn/' . $filename, base64_decode($image));
    // $profileimg  = $filename;
    // $filename = rand(99999, 99999999) . $file->getClientOriginalName();
    // $file->move(public_path('/cdn'), $filename);
    // $profileimg  = $filename;
    return $filename;
}

function getImage($filename)
{
    if(strpos($filename, url('/')) !== false) {
        return $filename;
    }
    return url('/').'/cdn/'.$filename;
}

function UserStatus()
{
    $arr = [
        // ' ' => ' ' ,
        '1' => 'مفعل',
        '0' => 'غير مفعل',
    ];
    return $arr;
}

function DriverTypes()
{
    $arr = [
        // ' ' => ' ' ,
        'internal' => 'داخلي',
        'external' => 'خارجي',
    ];
    return $arr;
}
function role()
{
    $arr = [
        // ' ' => ' ' ,
        'admin' => 'مدير',
        'branch' => 'فرع',
        'employee' => 'موظف',
    ];
    return $arr;
}

function CarTypes()
{
    $arr = [
        // ' ' => ' ' ,
        'car' => 'سيارة',
        'motorcycle' => 'دراجه ناريه',
    ];
    return $arr;
}
function TransferStatus()
{
    $arr = [
        // ' ' => ' ' ,
        '1' => 'تم السداد',
        '0' => ' لم يتم السداد',
    ];
    return $arr;
}
function BooleanChoise()
{
    $arr = [
        ' ' => ' ' ,
        '1' => 'نعم',
        '0' => ' لا',
    ];
    return $arr;
}
function ContactUs()
{
    $arr = [
        'new' => 'جديد',
        'reviewd' => ' تمت المراجعه' ,
        'called' => 'تم الاتصال',
        'wait' => ' انتظار',
        'not answer' => ' لم يتم الرد',
    ];
    return $arr;
}
function BooleanChoices()
{
    $arr = [
        ' ' => ' ' ,
        'Admin' => 'Admin',
        'Reviewer' => ' Reviewer',
        'CustomerServ' => ' CustomerServ',
        'WebAdmin' => ' WebAdmin',
        'User' => ' User',
    ];
    return $arr;
}
function CarMaintenanceTypes()
{
    $arr = [
        'cat1' => 'المحروقات',
        'cat2' => 'صيانة ميكانيكية',
        'cat3' => 'صيانة سمكرة',
        'cat4' => 'صيانة الكفرات والبنشر',
        'cat5' => 'صيانة الفحمات',
        'cat6' => 'صيانة البواجي',
        'cat7' => 'صيانة اللمبات',
        'cat8' => 'تغيرالبطارية ',
        'cat9' => 'صيانة عامة',
        'cat10' => 'اخري',
        
    ];
    return $arr;
}
function PaymentMethod()
{
    $cats = \App\Models\PaymentMethod::get();
     $arr = [''=> 'اختر طريقع الدفع'];
     foreach ($cats as $item) {
       $arr[$item->id] = $item->name;
        
    }
     return $arr;
    // $arr = [
    //     // '' => ' ' ,
    //     '1' => 'الدفع مقدما',
    //     '0' => ' الدفع عند الاستلام  ',
        
   
}
function ReturnPackages()
{
    $arr = [
        '' => ' ' ,
        '1' => 'نعم',
        '0' => ' لا  ',
        
        
    ];
    return $arr;
}

function ReceivingCity()
{
    $arr = [
        ' ' => '',
        '  ' => '   ',
        
        
    ];
    return $arr;
}

function SuggestedDrivers()
{
    $cats = \App\Models\Driver::get();
    $arr = [''=> 'اختر السائق'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->the_driver_s_name;
        
    }
    return $arr;
}

function StoreOrCompany()
{
    $cats = \App\Models\Company::get();
    $arr = [''=> 'اختر الشركه او المتجر'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;
        
    }
    return $arr;
}

function DriverReviewed()
{
    $arr = [
        '0' => ' لم تتم المراجعه',
        '1' => 'تمت المراجعه',
    ];
    return $arr;
}

function OrderTypes()
{
    $arr = [
        'internal' => 'داخلي',
        'external' => 'خارجي',
    ];
    return $arr;
}

function DriverType()
{
    $arr = [
        'employee' => 'موظف',
        'not_employee' => 'غير موظف',
    ];
    return $arr;
}
function UserRole()
{
    $arr = [
        'user' => 'مستخدم',
        'admin' => 'مدير',
        // 'company' => 'شركة',
    ];
    return $arr;
}
function ProductType()
{
    $arr = [
        'rent' => 'ايجار',
        'sale' => 'بيع',
    ];
    return $arr;
}

function GetCount($table,$column, $value, $operator = '=')
{
    if ($column != '') {
        // 
        return \DB::table($table)->where($column, $operator, $value)->count();
    }else{
        return \DB::table($table)->count();
    }
}
function Admins()
{
    $cats = \App\Models\Admin::get();
    $arr = [];
    $arr[''] = 'اختر المستخدم';
    foreach ($cats as $item) {
            $arr[$item->id] = $item->name;
    }
    return $arr;
}
function PermissionModels()
{
    return [ 'company', 'car', 'order', 'user' , 'driver' , 'car_maintenance' 
];
}
function Roles()
{
    $cats = \App\Models\Role::get();
    $arr = [];
    foreach ($cats as $item) {
            $arr[$item->id] = $item->name;
    }
    return $cats;
}
function RolesList()
{
    $cats = \App\Models\Role::get();
    $arr = [];
    foreach ($cats as $item) {
            $arr[$item->id] = $item->name;
    }
    return $arr;
}

function CheckPermission($key)
{
    if(auth()->user()->active == '0' )
    {
        return false;
    }
    if(auth()->user()->role == 'admin' )
    {
        return true;
    }
    if(auth()->user()->role == 'branch' && !in_array('setting_show',$key) && !in_array('admin_show',$key) && !in_array('contact_us_show',$key) )
    {
        return true;
    }
    $role = auth()->user()->UserRole()->first();
    if( $role )
    {
        $permission = $role->Role()->first()->Permission()->whereIn('permission', $key)->first();
        if ($permission) {
            return true;
        }
    }
    return false;
}

function AllCity()
{
    return $cats = \App\Models\City::get();
    $arr = [''=> 'اختر   المدينه'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name_ar;
        
    }
    
    return $arr;
}

function AllCitys()
{
    $cats = \App\Models\City::get();
    $arr = [''=> 'اختر   المدينه'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;
        
    }
    
    return $arr;
}
function Branch()
{
    $cats = \App\Models\Admin::where('role', 'branch')->get();
    $arr = ['0'=> 'اختر الفرع'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;
        
    }
    
    return $arr;
}

function CitiesParent()
{
    $cats = \App\Models\City::where('parent', '0')->get();
    $arr = ['0'=> 'اختر   المدينه'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;
        
    }
    
    return $arr;
}
function Order()
{
     $cats = \App\Models\Order::get();
    $arr = [];
    foreach ($cats as $item) {
        $arr[$item->id] = '#-'.$item->id;
        
    }
    return $arr;
}
function Users()
{
     $cats = \App\Models\User::get();
    $arr = [];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;
        
    }
    return $arr;
}
function Color()
{
    $cats = \App\Models\Color::get();
    $arr = [];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->the_color;
        
    }
    return $arr;
}
function ManufacturingYear()
{
     $cats = \App\Models\ManufacturingYear::get();
    $arr = [];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->the_year;
        
    }
    return $arr;
}
function Car()
{
     $cats = \App\Models\Car::get();
    $arr = [''=> 'اختر السيارة'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;
        
    }
    return $arr;
}
////////////////////////////////////////
function TheCity($title = 'اختر المدينه')
{
    $cats = \App\Models\City::get();
    $arr = [''=> $title];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;
        
    }
    return $arr;
   
}
function TheCityP($title = 'اختر المدينه')
{
    $cats = \App\Models\City::where('parent', 0)->get();
    $arr = [''=> $title];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;
        
    }
    return $arr;
   
}

function Driver()
{
    $cats = \App\Models\Driver::get();
    $arr = [''=> 'اختر السائق'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->the_driver_s_name;
        
    }
    return $arr;
}

function AllColors()
{
    return $cats = \App\Models\Color::get();
    $arr = [];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name_ar;
        
    }
    return $arr;
}

function AllYears()
{
    return $items = \App\Models\Year::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;
        
    }
    return $arr;
}

function Cities()
{
    $items = \App\Models\City::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;
        
    }
    return $arr;
}

function AllCarTypes()
{
    return $cats = \App\Models\CarType::get();
}

function AllCarCarrierTypes()
{
    return $cats = \App\Models\CarCarrierType::get();
}

function AllCarMakers()
{
    return $cats = \App\Models\CarMaker::get();
}

function AllPriceLists()
{
    return $cats = \App\Models\PriceList::get();
}

function AllCarModels()
{
    return $cats = \App\Models\CarModel::get();
}

///// edit the status in the index page by ordering in the db ///// l status l be na5tarha mo4 benrglha tany w bn5tar bel tarteb beta3 l db ...
function OrderStatus($id = '')
{
    if ($id != '') {
        $row = \App\Models\OrderStatus::where('key',$id)->first();
        $arr = \App\Models\OrderStatus::where('sort', '>=', $row->sort)->orderBy('sort','asc')->pluck('name', 'key')->toArray();
    }else{
        $arr = \App\Models\OrderStatus::orderBy('sort','asc')->pluck('name', 'key')->toArray();
    }
    ///////////////////////////////////////////////////
    // $arr = [
    //     'init' => 'جديد',
    //     'confirmed' => 'تم التاكيد و الدفع',
    //     'processing' => 'جاري المعالجة',
    //     'in_source_branch' => 'في فرع الاستلام',
    //     'in_destination_branch' => 'في فرع التسليم',
    //     'canceled' => 'تم الالغاء',
    //     'finished' => 'تم الانتهاء',
    // ];
    
    return $arr;
}
function DriversList()
{
    $items = \App\Models\Driver::get();
    $arr = ['' => 'اختر السائق'];
    foreach ($items as $item) {
        $arr[$item->id] = $item->first_name . " " . $item->last_name ;
        
    }
    return $arr;
}

function Categories()
{
   $items = \App\Models\Category::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;
        
    }
    return $items;
}
function CategoriesList()
{
   $items = \App\Models\Category::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;
        
    }
    return $arr;
}
function Branchs()
{
   $items = \App\Models\Branch::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;
        
    }
    return $arr;
}
function sendSMS($destinations, $message)
    {
        if (substr($destinations, 0, 2) === '05') {
            $destinations = '966'.substr($destinations, 1);
        }elseif (substr($destinations, 0, 2) === '00') {
            $destinations = substr($destinations, 2);
        }elseif (substr($destinations, 0, 2) === '+') {
            $destinations = substr($destinations, 1);
        }elseif (substr($destinations, 0, 1) === '5') {
            $destinations = '966'.$destinations;
        }
        // $contextOptions['http'] = array('method' => 'POST', 'header'=>'Content-type: application/json', 'content'=> json_encode($jsonObj), 'max_redirects'=>0, 'protocol_version'=> 1.0, 'timeout'=>10, 'ignore_errors'=>TRUE);
        // $contextResouce  = stream_context_create($contextOptions);
        // $url = "http://www.alfa-cell.com/api/msgSend.php";
        // $arrayResult = file($url, FILE_IGNORE_NEW_LINES, $contextResouce);
        // $result = $arrayResult[0];
        $username = "Aljeri";           // اسم المستخدم الخاص بك في الموقع 
        $password = "SmSaljeri_1330";       // كلمة المرور الخاصة بك 
        $destinations = $destinations; //الارقام المرسل لها  ,, يتم وضع فاصلة بين الارقام المراد الارسال لها 
        $message = $message;      // محتوى الرسالة 
        $sender = "Aljeri_TMS";           // اسم المرسل الخاص بك المفعل  في الموقع 
        $url = "http://www.jawalbsms.ws/api.php/sendsms?user=$username&pass=$password&to=$destinations&message=$message&sender=$sender";

        $ch = curl_init($url); // init the curl with jawalb API url
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);   
        curl_setopt($ch, CURLOPT_HEADER, 0);
        $data = curl_exec($ch);  //run curl api call, on success curl call, $data will contain the API call response
        curl_close($ch);
        // print_r($data);
    
        return $data;
    }
?>