<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Notifications\Notifiable;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Company extends Authenticatable implements JWTSubject
{
    use Notifiable;
    protected $table='companies';
    protected $fillable = [
        'name', 'email', 'password', 'phone', 'city_id' , 'adress_details' , 'commercial_record' , 'active' ,
        'inside_price' , 'outside_price' , 'inside_delivery' , 'outside_delivery' , 'inside_payment_method' ,
        'outside_payment_method','image' , 'return_cost'
    ];


    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
    public function Order()
    {
        return $this->Hasmany(Order::class, 'company_id');
    }
    public function BranchData()
    {
        return $this->morphOne(BranchData::class, 'taggable');
    }

    public function City()
    {
        return $this->belongsto(City::class, 'city_id');
    }

    public function Transfer()
    {
        return $this->Hasmany(Transfer::class, 'company_id');
    }
    
   
}
