<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Notifications\Notifiable;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Driver extends Authenticatable implements JWTSubject
{
    
    use Notifiable;
    protected $hidden = [
        'password', 'remember_token',
    ];
    protected $table='drivers';
    protected $fillable = [
        'first_name', 'last_name' , 'email' , 'phone' , 'identical_number' , 'password' , 'nationality' , 'license_number',
        'license_date_expiration' , 'car_id' , 'remember_token', 'identity_expiration_date', 'car_receive_date', 'type', 'commission',
        'identity_image' , 'license_image' , 'form_image' , 'car_receive_date_hijri' , 'identity_expiration_date_hijri',
        'license_expiration_date_hijri' , 'fixed_salary' , 'commission'
    ];
    protected $appends = [
        'cities',
    ];
/**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
    public function BranchData()
    {
        return $this->morphMany(BranchData::class, 'taggable');
    }
    public function DriverFianance()
    {
        return $this->Hasmany(DriverFianance::class, 'driver_id');
    }
    /**
     * Get all of the post's Files.
     */
    public function PlayerId()
    {
        return $this->morphMany(PlayerId::class, 'taggable');
    }
    public function Car()
    {
        return $this->belongsto(Car::class, 'car_id');
    }
    
    public function DriverCity()
    {
        return $this->Hasmany(DriverCity::class, 'driver_id');
    }

    public function Order()
    {
        return $this->Hasmany(Order::class, 'driver_id');
    }

    public function Invoice()
    {
        return $this->hasManyThrough(
            Invoice::class,
            Order::class,
            'driver_id', // Foreign key on orders table...
            'order_id', // Foreign key on invoices table...
            'id', // Local key on countries table...
            'id' // Local key on users table...
        );
    }
   

    public function getCitiesAttribute()
    {
        return $this->DriverCity()->pluck('city_id')->toArray();
    }
}
