<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $table='orders';
    protected $fillable = [
        'recipent_name', 'phone', 'city_id' , 'adress_details' , 'packages_number' , 'price'  , 'notes' , 'payment_method_id' , 
        'notes' , 'user_id' , 'company_id' , 'status' ,'refrence_no', 'serial', 'serial_no', 'driver_id', 'collected'
    ];

    public static function getLevels($status)
    {
        $levels = [];
        switch ($status) {
            case 'new':
                $levels = ['init', 'not_received'];
                break;
            case 'not_received':
                $levels = ['init'];
                break;
            case 'init':
                $levels = ['at_madar'];
                break;
            case 'at_madar':
                $levels = ['processed', 'at_office'];
                break;
            case 'processed':
                $levels = ['at_office'];
                break;
            case 'at_office':
                $levels = ['deliver_failed', 'delivered'];
                break;
            case 'deliver_failed':
                $levels = ['delivered', 'returned'];
                break;
            case 'delivered':
                $levels = ['returned'];
                break;
        }
        return $levels;
    }
    public function Invoice()
    {
        return $this->Hasmany(Invoice::class, 'order_id');
    }

    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function Driver()
    {
        return $this->belongsTo(Driver::class, 'driver_id');
    }

    public function Company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }
    public function City()
    {
        return $this->belongsTo(City::class, 'city_id');
    }
    public function PaymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'payment_method_id');
    }
    public function OrderLog()
    {
        return $this->Hasmany(OrderLog::class, 'order_id');
    }

    public function Transfer()
    {
        return $this->Hasmany(Transfer::class, 'order_id');
    }
    public function BranchData()
    {
        return $this->morphOne(BranchData::class, 'taggable');
    }
    public function OrderStatus()
    {
        return $this->belongsTo(OrderStatus::class, 'status', 'key');
    }
  
}
